//LLAMA2-13B DATASET v1.0 Category: Sorting ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ARRAY_SIZE 10

// Define a structure to hold the array elements
struct HappySortElement {
    int value;
    char color;
};

// Define a function to generate random numbers and colors
void generateRandomElements(struct HappySortElement arr[ARRAY_SIZE]) {
    int i, j;
    for (i = 0; i < ARRAY_SIZE; i++) {
        arr[i].value = rand() % 100;
        arr[i].color = (char)(rand() % 2 ? 'R' : 'G');
    }
}

// Define a function to sort the array using C sorting
void happySort(struct HappySortElement arr[ARRAY_SIZE]) {
    int i, j, min_idx;
    for (i = 0; i < ARRAY_SIZE - 1; i++) {
        min_idx = i;
        for (j = i + 1; j < ARRAY_SIZE; j++) {
            if (arr[j].value < arr[min_idx].value) {
                min_idx = j;
            }
        }
        if (min_idx != i) {
            struct HappySortElement temp = arr[i];
            arr[i] = arr[min_idx];
            arr[min_idx] = temp;
        }
    }
}

int main() {
    struct HappySortElement arr[ARRAY_SIZE];
    generateRandomElements(arr);
    printf("Original Array: ");
    for (int i = 0; i < ARRAY_SIZE; i++) {
        printf("%d%c", arr[i].value, arr[i].color);
    }
    printf("\n");
    happySort(arr);
    printf("Sorted Array: ");
    for (int i = 0; i < ARRAY_SIZE; i++) {
        printf("%d%c", arr[i].value, arr[i].color);
    }
    printf("\n");
    return 0;
}