//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Weather data structure
typedef struct WeatherData {
  float temperature;
  float humidity;
  float windSpeed;
  float precipitation;
} WeatherData;

// Function to generate random weather data
WeatherData generateWeatherData() {
  WeatherData weatherData;

  // Generate random temperature
  weatherData.temperature = (float)(rand() % 100) / 10;

  // Generate random humidity
  weatherData.humidity = (float)(rand() % 100) / 100;

  // Generate random wind speed
  weatherData.windSpeed = (float)(rand() % 100) / 10;

  // Generate random precipitation
  weatherData.precipitation = (float)(rand() % 100) / 100;

  return weatherData;
}

// Function to print weather data
void printWeatherData(WeatherData weatherData) {
  printf("Temperature: %.1f degrees Celsius\n", weatherData.temperature);
  printf("Humidity: %.1f%%\n", weatherData.humidity * 100);
  printf("Wind speed: %.1f km/h\n", weatherData.windSpeed);
  printf("Precipitation: %.1f mm/h\n", weatherData.precipitation);
}

// Main function
int main() {
  // Seed random number generator
  srand(time(NULL));

  // Generate weather data
  WeatherData weatherData = generateWeatherData();

  // Print weather data
  printWeatherData(weatherData);

  return 0;
}