//GPT-4o-mini DATASET v1.0 Category: Wireless Network Scanner ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <linux/wireless.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <ifaddrs.h>
#include <errno.h>
#include <fcntl.h>

#define MAX_NETWORKS 50
#define SSID_SIZE 32

struct wifi_network {
    char ssid[SSID_SIZE];
    int signal_strength;
};

void scan_networks(struct wifi_network *networks, int *count) {
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("Socket creation failed");
        exit(EXIT_FAILURE);
    }

    struct iwreq req;
    memset(&req, 0, sizeof(struct iwreq));
    
    // Set the interface for scanning
    strcpy(req.ifr_name, "wlan0");

    // Attempt to scan for networks
    if (ioctl(sockfd, SIOCSIWSCAN, &req) < 0) {
        perror("Network scan failed");
        close(sockfd);
        exit(EXIT_FAILURE);
    }
    
    sleep(2); // Wait for a while to collect the scan results

    // Retrieve scan results
    struct iw_scan_req scan_req;
    memset(&scan_req, 0, sizeof(scan_req));
    
    if (ioctl(sockfd, SIOCGIWSCAN, &req) < 0) {
        perror("Error in getting scan results");
        close(sockfd);
        exit(EXIT_FAILURE);
    }

    // Dummy data for demonstration, as retrieving actual scan data
    // is highly interface-dependent, and requires right permissions.
    for (int i = 0; i < *count; i++) {
        snprintf(networks[i].ssid, SSID_SIZE, "Network_%d", i + 1);
        networks[i].signal_strength = rand() % 100; // Random signal for demo
    }

    *count = 10; // Simulated found networks

    close(sockfd);
}

void display_networks(struct wifi_network *networks, int count) {
    printf("\nAvailable Wireless Networks:\n");
    printf("-----------------------------------\n");
    printf("SSID\t\tSignal Strength\n");
    printf("-----------------------------------\n");

    for (int i = 0; i < count; i++) {
        printf("%-16s\t%d%%\n", networks[i].ssid, networks[i].signal_strength);
    }
}

int main() {
    struct wifi_network networks[MAX_NETWORKS];
    int network_count = MAX_NETWORKS;

    srand(time(NULL)); // Seed for random number generation

    // Scan for networks
    scan_networks(networks, &network_count);

    // Display the networks found
    display_networks(networks, network_count);

    return 0;
}