//GPT-4o-mini DATASET v1.0 Category: Threading Library Implementation ; Style: Romeo and Juliet
#include <stdio.h>
#include <pthread.h>
#include <string.h>
#include <unistd.h>

#define MESSAGE_LENGTH 256
#define THREAD_COUNT 2

pthread_mutex_t mutex;
char message[MESSAGE_LENGTH];

void* romeo(void* arg) {
    char* romeo_msg = "O, Juliet! My heart beats for thee!";
    for (int i = 0; i < 5; i++) {
        pthread_mutex_lock(&mutex);
        snprintf(message, MESSAGE_LENGTH, "Romeo: %s", romeo_msg);
        printf("%s\n", message);
        pthread_mutex_unlock(&mutex);
        sleep(1); // Simulate time passing
    }
    return NULL;
}

void* juliet(void* arg) {
    char* juliet_msg = "O, Romeo! Thy words are but poetry!";
    for (int i = 0; i < 5; i++) {
        pthread_mutex_lock(&mutex);
        snprintf(message, MESSAGE_LENGTH, "Juliet: %s", juliet_msg);
        printf("%s\n", message);
        pthread_mutex_unlock(&mutex);
        sleep(1); // Simulate time passing
    }
    return NULL;
}

int main() {
    pthread_t threads[THREAD_COUNT];
    pthread_mutex_init(&mutex, NULL);
    
    // Create threads for Romeo and Juliet
    pthread_create(&threads[0], NULL, romeo, NULL);
    pthread_create(&threads[1], NULL, juliet, NULL);
    
    // Join threads to ensure complete execution
    for (int i = 0; i < THREAD_COUNT; i++) {
        pthread_join(threads[i], NULL);
    }
    
    // Destroy mutex
    pthread_mutex_destroy(&mutex);
    
    printf("Their love is eternal, though the night is dark.\n");
    return 0;
}