//GEMINI-pro DATASET v1.0 Category: Socket programming ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>

// Define the server's address and port
#define SERVER_ADDR "127.0.0.1"
#define SERVER_PORT 8080

// Define the maximum size of the message buffer
#define MAX_MSG_SIZE 1024

// Create a new socket
int create_socket() {
    // Create a new socket
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    // Return the socket descriptor
    return sockfd;
}

// Connect to the server
int connect_to_server(int sockfd) {
    // Create the server's address
    struct sockaddr_in serv_addr;
    memset(&serv_addr, 0, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = inet_addr(SERVER_ADDR);
    serv_addr.sin_port = htons(SERVER_PORT);

    // Connect to the server
    if (connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
        perror("connect");
        exit(EXIT_FAILURE);
    }

    // Return the socket descriptor
    return sockfd;
}

// Send a message to the server
int send_message(int sockfd, char *message) {
    // Send the message to the server
    int n = send(sockfd, message, strlen(message), 0);
    if (n < 0) {
        perror("send");
        exit(EXIT_FAILURE);
    }

    // Return the number of bytes sent
    return n;
}

// Receive a message from the server
int receive_message(int sockfd, char *buffer) {
    // Receive the message from the server
    int n = recv(sockfd, buffer, MAX_MSG_SIZE, 0);
    if (n < 0) {
        perror("recv");
        exit(EXIT_FAILURE);
    }

    // Return the number of bytes received
    return n;
}

// Close the socket
void close_socket(int sockfd) {
    // Close the socket
    close(sockfd);
}

// Main function
int main() {
    // Create a new socket
    int sockfd = create_socket();

    // Connect to the server
    sockfd = connect_to_server(sockfd);

    // Send a message to the server
    char message[] = "Hello, world!";
    send_message(sockfd, message);

    // Receive a message from the server
    char buffer[MAX_MSG_SIZE];
    receive_message(sockfd, buffer);

    // Print the message from the server
    printf("Message from server: %s\n", buffer);

    // Close the socket
    close_socket(sockfd);

    return 0;
}