//GEMINI-pro DATASET v1.0 Category: Fitness Tracker ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

typedef struct {
  int steps;
  int distance;
  int calories;
  int heart_rate;
} FitnessData;

FitnessData getFitnessData() {
  FitnessData data;

  // Simulate taking steps
  data.steps = rand() % 10000;

  // Calculate distance based on steps
  data.distance = data.steps * 0.0005;

  // Simulate burning calories
  data.calories = rand() % 500;

  // Simulate heart rate
  data.heart_rate = rand() % 150;

  return data;
}

int main() {
  // Create a fitness tracker for you and your beloved
  FitnessData myData, yourData;

  // Get fitness data for both of you
  myData = getFitnessData();
  yourData = getFitnessData();

  // Calculate the total steps, distance, calories, and heart rate
  int totalSteps = myData.steps + yourData.steps;
  double totalDistance = myData.distance + yourData.distance;
  int totalCalories = myData.calories + yourData.calories;
  int totalHeartRate = (myData.heart_rate + yourData.heart_rate) / 2;

  printf("Our Fitness Journey Together\n");
  printf("----------------------------\n");
  printf("Total Steps: %d\n", totalSteps);
  printf("Total Distance: %.2f miles\n", totalDistance);
  printf("Total Calories Burned: %d\n", totalCalories);
  printf("Average Heart Rate: %d bpm\n", totalHeartRate);

  // Write a romantic message based on the fitness data
  if (totalSteps > 10000) {
    printf("\nWow, we've taken over 10,000 steps together! I'm so proud of us.\n");
  } else if (totalSteps > 5000) {
    printf("\nWe've walked over 5,000 steps together! That's amazing.\n");
  } else {
    printf("\nWe've had a great time walking together today.\n");
  }

  if (totalDistance > 5.0) {
    printf("We've covered over 5 miles together! We're unstoppable.\n");
  } else if (totalDistance > 2.0) {
    printf("We've walked over 2 miles together! That's quite a distance.\n");
  } else {
    printf("We've walked a good distance together. I love spending time with you.\n");
  }

  if (totalCalories > 500) {
    printf("We've burned over 500 calories together! We're a fitness powerhouse.\n");
  } else if (totalCalories > 250) {
    printf("We've burned over 250 calories together! That's a great workout.\n");
  } else {
    printf("We've had a light workout together. But it's the time we spent together that matters most.\n");
  }

  if (totalHeartRate > 120) {
    printf("Our hearts are racing together! I love the feeling of being close to you.\n");
  } else if (totalHeartRate > 100) {
    printf("Our hearts are beating in sync. I feel so connected to you.\n");
  } else {
    printf("We've had a relaxing walk together. It's nice to take things easy sometimes.\n");
  }

  printf("\nI love you more than words can say. Let's keep walking together through life's adventures.\n");

  return 0;
}