//Code Llama-13B DATASET v1.0 Category: Data mining ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <stdint.h>

// Define a struct to hold the data
typedef struct {
  char *name;
  int age;
  float height;
  bool is_male;
} Person;

// Define a function to initialize a Person struct
void init_person(Person *person, char *name, int age, float height, bool is_male) {
  person->name = name;
  person->age = age;
  person->height = height;
  person->is_male = is_male;
}

// Define a function to print a Person struct
void print_person(Person *person) {
  printf("Name: %s\n", person->name);
  printf("Age: %d\n", person->age);
  printf("Height: %f\n", person->height);
  printf("Male: %s\n", person->is_male ? "Yes" : "No");
}

// Define a function to sort an array of Person structs based on age
void sort_by_age(Person *people, int num_people) {
  for (int i = 0; i < num_people - 1; i++) {
    for (int j = i + 1; j < num_people; j++) {
      if (people[i].age > people[j].age) {
        Person temp = people[i];
        people[i] = people[j];
        people[j] = temp;
      }
    }
  }
}

// Define a function to sort an array of Person structs based on height
void sort_by_height(Person *people, int num_people) {
  for (int i = 0; i < num_people - 1; i++) {
    for (int j = i + 1; j < num_people; j++) {
      if (people[i].height > people[j].height) {
        Person temp = people[i];
        people[i] = people[j];
        people[j] = temp;
      }
    }
  }
}

// Define a function to sort an array of Person structs based on name
void sort_by_name(Person *people, int num_people) {
  for (int i = 0; i < num_people - 1; i++) {
    for (int j = i + 1; j < num_people; j++) {
      if (strcmp(people[i].name, people[j].name) > 0) {
        Person temp = people[i];
        people[i] = people[j];
        people[j] = temp;
      }
    }
  }
}

// Define a function to print the top n oldest people
void print_top_n_oldest(Person *people, int num_people, int n) {
  // Sort the people by age
  sort_by_age(people, num_people);

  // Print the top n oldest people
  for (int i = 0; i < n; i++) {
    print_person(&people[i]);
  }
}

// Define a function to print the top n tallest people
void print_top_n_tallest(Person *people, int num_people, int n) {
  // Sort the people by height
  sort_by_height(people, num_people);

  // Print the top n tallest people
  for (int i = 0; i < n; i++) {
    print_person(&people[i]);
  }
}

// Define a function to print the top n people with the longest names
void print_top_n_longest_names(Person *people, int num_people, int n) {
  // Sort the people by name
  sort_by_name(people, num_people);

  // Print the top n people with the longest names
  for (int i = 0; i < n; i++) {
    print_person(&people[i]);
  }
}

// Main function
int main() {
  // Create an array of Person structs
  Person people[] = {
    {"Alice", 25, 160.0, true},
    {"Bob", 30, 180.0, false},
    {"Charlie", 20, 170.0, true},
    {"David", 25, 175.0, false},
    {"Eve", 35, 150.0, true},
    {"Frank", 40, 190.0, false},
  };
  int num_people = sizeof(people) / sizeof(Person);

  // Print the top 2 oldest people
  print_top_n_oldest(people, num_people, 2);

  // Print the top 2 tallest people
  print_top_n_tallest(people, num_people, 2);

  // Print the top 2 people with the longest names
  print_top_n_longest_names(people, num_people, 2);

  return 0;
}