//Code Llama-13B DATASET v1.0 Category: Queue Implementation ; Style: Claude Shannon
/*
 * Queue Implementation using a circular buffer
 */
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define MAX_SIZE 100

typedef struct {
    int front;
    int rear;
    int size;
    int buffer[MAX_SIZE];
} Queue;

void init(Queue *q) {
    q->front = 0;
    q->rear = 0;
    q->size = 0;
}

bool isEmpty(Queue *q) {
    return (q->size == 0);
}

bool isFull(Queue *q) {
    return (q->size == MAX_SIZE);
}

void enqueue(Queue *q, int data) {
    if (isFull(q)) {
        printf("Queue is full\n");
        return;
    }
    q->buffer[q->rear] = data;
    q->rear = (q->rear + 1) % MAX_SIZE;
    q->size++;
}

int dequeue(Queue *q) {
    if (isEmpty(q)) {
        printf("Queue is empty\n");
        return -1;
    }
    int data = q->buffer[q->front];
    q->front = (q->front + 1) % MAX_SIZE;
    q->size--;
    return data;
}

void print(Queue *q) {
    printf("Queue: ");
    for (int i = 0; i < q->size; i++) {
        printf("%d ", q->buffer[(q->front + i) % MAX_SIZE]);
    }
    printf("\n");
}

int main() {
    Queue q;
    init(&q);

    enqueue(&q, 1);
    enqueue(&q, 2);
    enqueue(&q, 3);
    print(&q);

    printf("Dequeued: %d\n", dequeue(&q));
    print(&q);

    return 0;
}