//GEMINI-pro DATASET v1.0 Category: Socket programming ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

// Define the port number for the server
#define PORT 8080

// Create a socket that will be used to communicate with the client
int create_socket() {
  // Create a socket with the AF_INET (IPv4) address family and the SOCK_STREAM (TCP) socket type
  int sockfd = socket(AF_INET, SOCK_STREAM, 0);

  if (sockfd == -1) {
    perror("socket");
    exit(EXIT_FAILURE);
  }

  // Return the socket descriptor
  return sockfd;
}

// Bind the socket to the specified IP address and port
void bind_socket(int sockfd, char *ip_address) {
  // Create a sockaddr_in structure to store the IP address and port of the server
  struct sockaddr_in server_addr;

  // Set the family of the sockaddr_in structure to AF_INET (IPv4)
  server_addr.sin_family = AF_INET;

  // Set the port of the sockaddr_in structure to the specified port number
  server_addr.sin_port = htons(PORT);

  // Set the IP address of the sockaddr_in structure to the specified IP address
  inet_pton(AF_INET, ip_address, &server_addr.sin_addr);

  // Bind the socket to the sockaddr_in structure
  if (bind(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
    perror("bind");
    exit(EXIT_FAILURE);
  }
}

// Listen for incoming connections on the socket
void listen_for_connections(int sockfd) {
  // Listen for incoming connections on the socket with a backlog of 5
  if (listen(sockfd, 5) == -1) {
    perror("listen");
    exit(EXIT_FAILURE);
  }
}

// Accept an incoming connection on the socket
int accept_connection(int sockfd) {
  // Accept an incoming connection on the socket
  int clientfd = accept(sockfd, NULL, NULL);

  if (clientfd == -1) {
    perror("accept");
    exit(EXIT_FAILURE);
  }

  // Return the client socket descriptor
  return clientfd;
}

// Recieve data from the client
int recieve_data(int clientfd) {
  // Create a buffer to store the data received from the client
  char buffer[1024];

  // Receive data from the client
  int n = recv(clientfd, buffer, sizeof(buffer), 0);

  if (n == -1) {
    perror("recv");
    exit(EXIT_FAILURE);
  }

  // Return the number of bytes received
  return n;
}

// Send data to the client
int send_data(int clientfd, char *data) {
  // Send data to the client
  int n = send(clientfd, data, strlen(data), 0);

  if (n == -1) {
    perror("send");
    exit(EXIT_FAILURE);
  }

  // Return the number of bytes sent
  return n;
}

// Close the socket
void close_socket(int sockfd) {
  // Close the socket
  if (close(sockfd) == -1) {
    perror("close");
    exit(EXIT_FAILURE);
  }
}

// Main function
int main(int argc, char *argv[]) {
  // Create a socket
  int sockfd = create_socket();

  // Bind the socket to the specified IP address and port
  bind_socket(sockfd, argv[1]);

  // Listen for incoming connections on the socket
  listen_for_connections(sockfd);

  // Accept an incoming connection on the socket
  int clientfd = accept_connection(sockfd);

  // Recieve data from the client
  int n = recieve_data(clientfd);

  // Send data to the client
  send_data(clientfd, "Hello, world!");

  // Close the socket
  close_socket(sockfd);

  return 0;
}