//Gemma-7B DATASET v1.0 Category: Scientific Calculator Implementation ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_BUFFER_SIZE 1024

typedef struct calculator_state {
  char buffer[MAX_BUFFER_SIZE];
  int pos;
  double result;
  double operand;
} calculator_state;

calculator_state state;

void calculator_init() {
  state.pos = 0;
  state.result = 0.0;
  state.operand = 0.0;
  memset(state.buffer, '\0', MAX_BUFFER_SIZE);
}

void calculator_add(double num) {
  state.operand = num;
  state.buffer[state.pos++] = '+';
}

void calculator_subtract(double num) {
  state.operand = num;
  state.buffer[state.pos++] = '-';
}

void calculator_multiply(double num) {
  state.operand = num;
  state.buffer[state.pos++] = '*';
}

void calculator_divide(double num) {
  state.operand = num;
  state.buffer[state.pos++] = '/';
}

void calculator_equal() {
  double op = state.operand;
  double result = state.result + op * state.operand;
  state.result = result;
  state.pos = 0;
  memset(state.buffer, '\0', MAX_BUFFER_SIZE);
}

int main() {
  calculator_init();

  // Example usage:
  calculator_add(5.0);
  calculator_multiply(2.0);
  calculator_equal();

  printf("The result is: %.2lf\n", state.result);

  return 0;
}