//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of products that can be stored in the inventory.
#define MAX_PRODUCTS 100

// Define the structure of a product.
typedef struct product {
    char name[50];        // The name of the product.
    int quantity;         // The quantity of the product in stock.
    double price;          // The price of the product.
} product;

// Declare the array of products.
product inventory[MAX_PRODUCTS];

// Declare the number of products in the inventory.
int num_products = 0;

// Function to add a product to the inventory.
void add_product(char *name, int quantity, double price) {
    // Check if the inventory is full.
    if (num_products >= MAX_PRODUCTS) {
        printf("Error: The inventory is full. Cannot add more products.\n");
        return;
    }

    // Copy the product information into the inventory.
    strcpy(inventory[num_products].name, name);
    inventory[num_products].quantity = quantity;
    inventory[num_products].price = price;

    // Increment the number of products in the inventory.
    num_products++;
}

// Function to remove a product from the inventory.
void remove_product(char *name) {
    // Find the product in the inventory.
    int i;
    for (i = 0; i < num_products; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            break;
        }
    }

    // Check if the product was found.
    if (i == num_products) {
        printf("Error: The product was not found in the inventory.\n");
        return;
    }

    // Remove the product from the inventory.
    for (; i < num_products - 1; i++) {
        inventory[i] = inventory[i + 1];
    }

    // Decrement the number of products in the inventory.
    num_products--;
}

// Function to update the quantity of a product in the inventory.
void update_quantity(char *name, int quantity) {
    // Find the product in the inventory.
    int i;
    for (i = 0; i < num_products; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            break;
        }
    }

    // Check if the product was found.
    if (i == num_products) {
        printf("Error: The product was not found in the inventory.\n");
        return;
    }

    // Update the quantity of the product in the inventory.
    inventory[i].quantity = quantity;
}

// Function to update the price of a product in the inventory.
void update_price(char *name, double price) {
    // Find the product in the inventory.
    int i;
    for (i = 0; i < num_products; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            break;
        }
    }

    // Check if the product was found.
    if (i == num_products) {
        printf("Error: The product was not found in the inventory.\n");
        return;
    }

    // Update the price of the product in the inventory.
    inventory[i].price = price;
}

// Function to print the inventory.
void print_inventory() {
    // Print the header of the inventory.
    printf("Product Inventory\n");
    printf("--------------------\n");
    printf("Name\tQuantity\tPrice\n");

    // Print the products in the inventory.
    int i;
    for (i = 0; i < num_products; i++) {
        printf("%s\t%d\t%.2f\n", inventory[i].name, inventory[i].quantity, inventory[i].price);
    }
}

// Main function.
int main() {
    // Add some products to the inventory.
    add_product("Apple", 10, 1.0);
    add_product("Banana", 20, 1.5);
    add_product("Orange", 30, 2.0);
    add_product("Grape", 40, 2.5);
    add_product("Strawberry", 50, 3.0);

    // Print the inventory.
    print_inventory();

    // Update the quantity of a product in the inventory.
    update_quantity("Apple", 20);

    // Update the price of a product in the inventory.
    update_price("Strawberry", 3.5);

    // Print the inventory.
    print_inventory();

    // Remove a product from the inventory.
    remove_product("Orange");

    // Print the inventory.
    print_inventory();

    return 0;
}