//Falcon-180B DATASET v1.0 Category: Geometric algorithms ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    int x, y;
} Point;

typedef struct {
    Point p1, p2, p3;
} Triangle;

typedef struct {
    Point center;
    double radius;
} Circle;

typedef struct {
    Point a, b, c, d;
} Quadrilateral;

typedef struct {
    Point center;
    double radius1, radius2;
} Ellipse;

void print_point(Point p) {
    printf("(%d, %d)\n", p.x, p.y);
}

void print_triangle(Triangle t) {
    printf("Triangle with points:\n");
    print_point(t.p1);
    print_point(t.p2);
    print_point(t.p3);
}

void print_circle(Circle c) {
    printf("Circle with center (%d, %d) and radius %.2f\n", c.center.x, c.center.y, c.radius);
}

void print_quadrilateral(Quadrilateral q) {
    printf("Quadrilateral with points:\n");
    print_point(q.a);
    print_point(q.b);
    print_point(q.c);
    print_point(q.d);
}

void print_ellipse(Ellipse e) {
    printf("Ellipse with center (%d, %d) and radii (%.2f, %.2f)\n", e.center.x, e.center.y, e.radius1, e.radius2);
}

int main() {
    Point p1 = {0, 0};
    Point p2 = {3, 4};
    Point p3 = {6, 0};

    // Create a triangle
    Triangle t = {p1, p2, p3};
    print_triangle(t);

    // Create a circle
    Circle c = {p2, 2.5};
    print_circle(c);

    // Create a quadrilateral
    Quadrilateral q = {{0, 0}, {3, 0}, {6, 4}, {3, 4}};
    print_quadrilateral(q);

    // Create an ellipse
    Ellipse e = {{3, 2}, 2, 1.5};
    print_ellipse(e);

    return 0;
}