//LLAMA2-13B DATASET v1.0 Category: String manipulation ; Style: scientific
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

// Function to reverse a string
void reverse_string(char *str) {
    int i, j;
    char temp;

    for (i = 0, j = strlen(str) - 1; i < j; i++, j--) {
        temp = str[i];
        str[i] = str[j];
        str[j] = temp;
    }
}

// Function to find the longest common prefix of two strings
int longest_common_prefix(char *str1, char *str2) {
    int i, j;
    char temp;

    for (i = 0, j = 0; i < strlen(str1) && j < strlen(str2); ) {
        if (str1[i] == str2[j]) {
            i++;
            j++;
        } else {
            break;
        }
    }

    return i;
}

// Function to find the shortest string that is a prefix of both str1 and str2
char *shortest_common_prefix(char *str1, char *str2) {
    int i, j;
    char temp;

    for (i = 0, j = 0; i < strlen(str1) && j < strlen(str2); ) {
        if (str1[i] == str2[j]) {
            i++;
            j++;
        } else {
            break;
        }
    }

    return str1 + i;
}

int main() {
    char str1[] = "The quick brown fox jumps over the lazy dog";
    char str2[] = "The quick brown fox jumps over the dog";

    // Reverse the first string
    reverse_string(str1);

    // Find the longest common prefix of the two strings
    int len = longest_common_prefix(str1, str2);

    // Find the shortest string that is a prefix of both strings
    char *prefix = shortest_common_prefix(str1, str2);

    // Print the results
    printf("Longest common prefix: %s\n", str1 + len);
    printf("Shortest common prefix: %s\n", prefix);

    return 0;
}