//Code Llama-13B DATASET v1.0 Category: Task Scheduler ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_TASKS 10

typedef struct {
  char name[30];
  int duration;
} Task;

void print_tasks(Task tasks[], int num_tasks) {
  printf("Tasks: \n");
  for (int i = 0; i < num_tasks; i++) {
    printf("%s (%d sec)\n", tasks[i].name, tasks[i].duration);
  }
}

void add_task(Task tasks[], int *num_tasks, char *name, int duration) {
  if (*num_tasks < MAX_TASKS) {
    strcpy(tasks[*num_tasks].name, name);
    tasks[*num_tasks].duration = duration;
    (*num_tasks)++;
  } else {
    printf("Cannot add more than %d tasks\n", MAX_TASKS);
  }
}

void remove_task(Task tasks[], int *num_tasks, int index) {
  if (index >= 0 && index < *num_tasks) {
    for (int i = index; i < *num_tasks - 1; i++) {
      tasks[i] = tasks[i + 1];
    }
    (*num_tasks)--;
  } else {
    printf("Invalid index\n");
  }
}

int main() {
  Task tasks[MAX_TASKS];
  int num_tasks = 0;

  add_task(tasks, &num_tasks, "Task 1", 5);
  add_task(tasks, &num_tasks, "Task 2", 10);
  add_task(tasks, &num_tasks, "Task 3", 15);

  print_tasks(tasks, num_tasks);

  remove_task(tasks, &num_tasks, 1);

  print_tasks(tasks, num_tasks);

  return 0;
}