//Code Llama-13B DATASET v1.0 Category: Socket programming ; Style: creative
// Unique C Socket Programming Example Program
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>

int main(int argc, char *argv[]) {
  // Create a socket
  int sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("socket");
    return 1;
  }

  // Initialize address struct
  struct sockaddr_in addr;
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_port = htons(8080);
  addr.sin_addr.s_addr = INADDR_ANY;

  // Bind address to socket
  if (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
    perror("bind");
    return 1;
  }

  // Listen for incoming connections
  if (listen(sock, 3) < 0) {
    perror("listen");
    return 1;
  }

  // Accept incoming connections
  struct sockaddr_in client;
  socklen_t client_len = sizeof(client);
  int client_sock = accept(sock, (struct sockaddr *)&client, &client_len);
  if (client_sock < 0) {
    perror("accept");
    return 1;
  }

  // Receive data from client
  char buf[1024];
  int recv_len = recv(client_sock, buf, 1024, 0);
  if (recv_len < 0) {
    perror("recv");
    return 1;
  }

  // Print received data
  printf("Received data: %s\n", buf);

  // Send data to client
  char *msg = "Hello, client!";
  if (send(client_sock, msg, strlen(msg), 0) < 0) {
    perror("send");
    return 1;
  }

  // Close socket
  close(client_sock);
  close(sock);

  return 0;
}