//GPT-4o-mini DATASET v1.0 Category: Packet Capturer with pcap library ; Style: post-apocalyptic
#include <stdio.h>
#include <pcap.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PACKET_SIZE 65536
#define PROMISCUOUS_MODE 1
#define CAPTURE_TIMEOUT 1000

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    printf("Captured a packet with length of [%d]\n", header->len);
    printf("Packet:\n");
    for (int i = 0; i < header->len; i++) {
        printf("%02x ", packet[i]);
        if (i % 16 == 15) {
            printf("\n");
        }
    }
    printf("\n\n");
}

int main() {
    char *dev;  // Device to capture packets
    char errbuf[PCAP_ERRBUF_SIZE];  
    pcap_t *handle; // Handle for pcap
    struct bpf_program fp; // For compiled filter
    char filter_exp[] = "ip"; // The filter expression
    int num_packets = 10; // Number of packets to capture

    // Stark silence falls upon the wiring of the world, find the device listen to broken whispers
    dev = pcap_lookupdev(errbuf);
    if (dev == NULL) {
        fprintf(stderr, "Could not find any device: %s\n", errbuf);
        return 1;
    }
    printf("Using device: %s\n", dev);

    handle = pcap_open_live(dev, MAX_PACKET_SIZE, PROMISCUOUS_MODE, CAPTURE_TIMEOUT, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return 2;
    }

    // Enforcing a filter as the remnants of civilization still crisscross the ether
    if (pcap_compile(handle, &fp, filter_exp, 0, PCAP_NETMASK_UNKNOWN) == -1) {
        fprintf(stderr, "Could not parse filter %s: %s\n", filter_exp, pcap_geterr(handle));
        return 2;
    }

    if (pcap_setfilter(handle, &fp) == -1) {
        fprintf(stderr, "Could not install filter %s: %s\n", filter_exp, pcap_geterr(handle));
        return 2;
    }

    pcap_freecode(&fp); // Release the compiled filter

    printf("Potion of a capture brewing...\n");
    pcap_loop(handle, num_packets, packet_handler, NULL);

    pcap_close(handle); // Clean up and close the handle
    printf("The echoes of the network captured. The end is upon us...\n");

    return 0;
}