//Falcon-180B DATASET v1.0 Category: Memory management ; Style: introspective
#include <stdio.h>
#include <stdlib.h>

void *my_malloc(size_t size) {
    void *ptr = malloc(size);
    if (ptr == NULL) {
        printf("Out of memory!\n");
        exit(1);
    }
    return ptr;
}

void *my_calloc(size_t count, size_t size) {
    void *ptr = calloc(count, size);
    if (ptr == NULL) {
        printf("Out of memory!\n");
        exit(1);
    }
    return ptr;
}

void *my_realloc(void *ptr, size_t size) {
    void *new_ptr = realloc(ptr, size);
    if (new_ptr == NULL) {
        printf("Out of memory!\n");
        exit(1);
    }
    return new_ptr;
}

void my_free(void *ptr) {
    free(ptr);
}

int main() {
    int *p = my_malloc(sizeof(int));
    *p = 42;
    printf("The number is %d\n", *p);
    my_free(p);

    int *q = my_calloc(10, sizeof(int));
    for (int i = 0; i < 10; i++) {
        q[i] = i * 2;
    }
    for (int i = 0; i < 10; i++) {
        printf("%d ", q[i]);
    }
    printf("\n");
    my_free(q);

    char *s = my_malloc(sizeof(char) * 20);
    strcpy(s, "Hello, world!");
    printf("The string is %s\n", s);
    my_free(s);

    return 0;
}