//Falcon2-11B DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Structure to represent an airplane
typedef struct {
    char origin[50];
    char destination[50];
    int capacity;
} Airplane;

// Structure to represent a passenger
typedef struct {
    char name[50];
    char passport[50];
    int age;
} Passenger;

// Structure to represent a bag
typedef struct {
    char number[50];
    int weight;
} Bag;

// Function to add a new airplane to the database
void addAirplane(Airplane* airplanes, int size, char* origin, char* destination, int capacity) {
    Airplane newAirplane;
    strcpy(newAirplane.origin, origin);
    strcpy(newAirplane.destination, destination);
    newAirplane.capacity = capacity;
    airplanes[size] = newAirplane;
}

// Function to remove an airplane from the database
void removeAirplane(Airplane* airplanes, int size, char* origin) {
    for (int i = 0; i < size; i++) {
        if (strcmp(airplanes[i].origin, origin) == 0) {
            for (int j = i; j < size - 1; j++) {
                airplanes[j] = airplanes[j + 1];
            }
            size--;
            break;
        }
    }
}

// Function to add a new passenger to the database
void addPassenger(Passenger* passengers, int size, char* name, char* passport, int age) {
    Passenger newPassenger;
    strcpy(newPassenger.name, name);
    strcpy(newPassenger.passport, passport);
    newPassenger.age = age;
    passengers[size] = newPassenger;
}

// Function to remove a passenger from the database
void removePassenger(Passenger* passengers, int size, char* name) {
    for (int i = 0; i < size; i++) {
        if (strcmp(passengers[i].name, name) == 0) {
            for (int j = i; j < size - 1; j++) {
                passengers[j] = passengers[j + 1];
            }
            size--;
            break;
        }
    }
}

// Function to add a new bag to the database
void addBag(Bag* bags, int size, char* number, int weight) {
    Bag newBag;
    strcpy(newBag.number, number);
    newBag.weight = weight;
    bags[size] = newBag;
}

// Function to remove a bag from the database
void removeBag(Bag* bags, int size, char* number) {
    for (int i = 0; i < size; i++) {
        if (strcmp(bags[i].number, number) == 0) {
            for (int j = i; j < size - 1; j++) {
                bags[j] = bags[j + 1];
            }
            size--;
            break;
        }
    }
}

// Function to assign bags to passengers
void assignBags(Passenger* passengers, Bag* bags, int size) {
    int i = 0;
    int j = 0;
    for (i = 0; i < size; i++) {
        for (j = 0; j < size; j++) {
            if (strcmp(passengers[i].name, bags[j].number) == 0) {
                printf("Bag %s assigned to passenger %s\n", bags[j].number, passengers[i].name);
                break;
            }
        }
    }
}

int main() {
    // Create an array of airplanes
    Airplane airplanes[10];
    int size = 0;

    // Create an array of passengers
    Passenger passengers[10];
    int passengerSize = 0;

    // Create an array of bags
    Bag bags[10];
    int bagSize = 0;

    // Add airplanes to the database
    addAirplane(airplanes, size, "New York", "Los Angeles", 120);
    addAirplane(airplanes, size, "Los Angeles", "Paris", 90);
    addAirplane(airplanes, size, "Paris", "London", 80);

    // Add passengers to the database
    addPassenger(passengers, passengerSize, "John", "ABC123", 25);
    addPassenger(passengers, passengerSize, "Jane", "DEF456", 30);
    addPassenger(passengers, passengerSize, "Bob", "GHI789", 35);

    // Add bags to the database
    addBag(bags, bagSize, "BAG1", 10);
    addBag(bags, bagSize, "BAG2", 20);
    addBag(bags, bagSize, "BAG3", 30);

    // Assign bags to passengers
    assignBags(passengers, bags, bagSize);

    // Remove an airplane from the database
    removeAirplane(airplanes, size, "New York");

    // Remove a passenger from the database
    removePassenger(passengers, passengerSize, "John");

    // Remove a bag from the database
    removeBag(bags, bagSize, "BAG1");

    // Print the updated database
    printf("Updated database:\n");
    printf("Airplanes:\n");
    for (int i = 0; i < size; i++) {
        printf("%s %s %d\n", airplanes[i].origin, airplanes[i].destination, airplanes[i].capacity);
    }
    printf("\nPassengers:\n");
    for (int i = 0; i < passengerSize; i++) {
        printf("%s %s %d\n", passengers[i].name, passengers[i].passport, passengers[i].age);
    }
    printf("\nBags:\n");
    for (int i = 0; i < bagSize; i++) {
        printf("%s %d\n", bags[i].number, bags[i].weight);
    }

    return 0;
}