//Code Llama-13B DATASET v1.0 Category: Interprocess communication ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define BUF_SIZE 1024
#define MSG_QUEUE_KEY 1234

struct msgbuf {
    long mtype;
    char mtext[BUF_SIZE];
};

int main() {
    int msgid;
    key_t key = MSG_QUEUE_KEY;
    struct msgbuf msg;
    int n;

    // create message queue
    msgid = msgget(key, IPC_CREAT | 0666);
    if (msgid == -1) {
        perror("msgget");
        exit(1);
    }

    // parent process
    if (fork() == 0) {
        // send message to queue
        msg.mtype = 1;
        sprintf(msg.mtext, "Hello, world!");
        n = msgsnd(msgid, &msg, sizeof(msg), 0);
        if (n == -1) {
            perror("msgsnd");
            exit(1);
        }

        // wait for child to receive message
        wait(NULL);

        // close message queue
        n = msgctl(msgid, IPC_RMID, NULL);
        if (n == -1) {
            perror("msgctl");
            exit(1);
        }

        exit(0);
    }

    // child process
    if (fork() == 0) {
        // receive message from queue
        n = msgrcv(msgid, &msg, sizeof(msg), 0, 0);
        if (n == -1) {
            perror("msgrcv");
            exit(1);
        }

        // print received message
        printf("Received message: %s\n", msg.mtext);

        // close message queue
        n = msgctl(msgid, IPC_RMID, NULL);
        if (n == -1) {
            perror("msgctl");
            exit(1);
        }

        exit(0);
    }

    // parent process waits for child to exit
    wait(NULL);

    return 0;
}