//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

static int callback(void *data, int argc, char **argv, char **azColName){
    printf("%s: ", (const char*)data);
    for(int i = 0; i < argc; i++){
        printf("%s = %s; ", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

int main() {
    sqlite3 *db;
    char *errMsg = 0;
    int rc;

    // Open a SQLite database
    rc = sqlite3_open("happy.db", &db);

    if(rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return(0);
    } else {
        printf("Opened database successfully! Let's spread some joy!\n");
    }

    // Create a table for storing happy quotes
    const char *sqlCreateTable = "CREATE TABLE IF NOT EXISTS QUOTES(" \
                             "ID INTEGER PRIMARY KEY AUTOINCREMENT," \
                             "QUOTE TEXT NOT NULL);";

    // Execute the SQL statement
    rc = sqlite3_exec(db, sqlCreateTable, 0, 0, &errMsg);
    if(rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Table created successfully! Time to add some happy quotes!\n");
    }

    // Insert some cheerful quotes
    const char *sqlInsertQuotes = "INSERT INTO QUOTES (QUOTE) VALUES "
                                   "('Happiness can be found even in the darkest of times, if one only remembers to turn on the light.'); "
                                   "INSERT INTO QUOTES (QUOTE) VALUES "
                                   "('The purpose of our lives is to be happy.'); "
                                   "INSERT INTO QUOTES (QUOTE) VALUES "
                                   "('Life is what happens when you’re busy making other plans.'); ";

    rc = sqlite3_exec(db, sqlInsertQuotes, 0, 0, &errMsg);
    if(rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Happy quotes inserted into the table! Feeling the joy!\n");
    }

    // Query the happy quotes
    printf("\nLet's read our happy quotes:\n");

    const char *sqlSelectQuotes = "SELECT * FROM QUOTES;";
    rc = sqlite3_exec(db, sqlSelectQuotes, callback, (void*)"Quote", &errMsg);
    if(rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Quotes retrieved successfully! Spread the joy around!\n");
    }

    // This is the perfect time to close the database connection
    sqlite3_close(db);
    printf("Database connection closed. Have a happy day ahead!\n");

    return 0;
}