//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 1000

typedef struct {
    char name[100];
    int votes;
} Candidate;

typedef struct {
    char name[100];
    int voterID;
    int voted;
} Voter;

Candidate candidates[MAX_CANDIDATES];
Voter voters[MAX_VOTERS];
int numCandidates;
int numVoters;

void addCandidate(char *name) {
    strcpy(candidates[numCandidates].name, name);
    candidates[numCandidates].votes = 0;
    numCandidates++;
}

void addVoter(char *name, int voterID) {
    strcpy(voters[numVoters].name, name);
    voters[numVoters].voterID = voterID;
    voters[numVoters].voted = 0;
    numVoters++;
}

void vote(int voterID, int candidateID) {
    for (int i = 0; i < numVoters; i++) {
        if (voters[i].voterID == voterID) {
            voters[i].voted = 1;
            for (int j = 0; j < numCandidates; j++) {
                if (candidates[j].name[0] == (char)(candidateID + 'A')) {
                    candidates[j].votes++;
                    break;
                }
            }
            break;
        }
    }
}

void displayResults() {
    printf("Results:\n");
    for (int i = 0; i < numCandidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    addCandidate("Alice");
    addCandidate("Bob");
    addCandidate("Charlie");

    addVoter("John", 1);
    addVoter("Jane", 2);
    addVoter("Jim", 3);

    vote(1, 0);
    vote(2, 1);
    vote(3, 0);

    displayResults();

    return 0;
}