//Falcon-180B DATASET v1.0 Category: Networking ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define PORT 8080
#define MAX 100
#define TRUE 1
#define FALSE 0
#define SERVER_SOCKET_FILE "server_socket"

int main(int argc, char *argv[]) {
    int opt = TRUE;
    int listening_socket, client_socket, new_socket, max_clients = 5;
    int master_socket, addrlen, new_addrlen, valread, sd;
    char buffer[MAX];
    struct sockaddr_in address;
    struct sockaddr_in client_address;
    int optval = 1;
    char *message = "Welcome to the surreal world of networking!\n";
    char filename[20];
    int fd;

    // Create socket
    listening_socket = socket(AF_INET, SOCK_STREAM, 0);

    if (listening_socket == 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    puts("Socket created");

    // Set options on the socket
    setsockopt(listening_socket, SOL_SOCKET, SO_REUSEADDR, (char *)&optval, sizeof(optval));

    address.sin_family = AF_INET;
    address.sin_addr.s_addr = INADDR_ANY;
    address.sin_port = htons(PORT);

    // Bind the socket
    if (bind(listening_socket, (struct sockaddr *)&address, sizeof(address)) < 0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }

    puts("Socket bound");

    // Listen for incoming connections
    if (listen(listening_socket, max_clients) < 0) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    puts("Socket now listening");

    // Accept a connection
    addrlen = sizeof(client_address);
    new_socket = accept(listening_socket, (struct sockaddr *)&client_address, &addrlen);

    if (new_socket < 0) {
        perror("accept");
        exit(EXIT_FAILURE);
    }

    puts("Connection accepted");

    // Send a message to the client
    send(new_socket, message, strlen(message), 0);

    // Close the client socket
    close(new_socket);

    // Close the listening socket
    close(listening_socket);

    return 0;
}