//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the weather types
#define SUNNY 0
#define RAINY 1
#define SNOWY 2
#define WINDY 3
#define FOGGY 4

// Define the weather probabilities
#define SUNNY_PROB 0.4
#define RAINY_PROB 0.3
#define SNOWY_PROB 0.2
#define WINDY_PROB 0.1
#define FOGGY_PROB 0.0

// Define the temperature ranges
#define MIN_TEMP 0
#define MAX_TEMP 100

// Get a random number between 0 and 1
double get_random_number() {
  return (double)rand() / (double)RAND_MAX;
}

// Get a random weather type
int get_random_weather_type() {
  double r = get_random_number();

  if (r < SUNNY_PROB) {
    return SUNNY;
  } else if (r < SUNNY_PROB + RAINY_PROB) {
    return RAINY;
  } else if (r < SUNNY_PROB + RAINY_PROB + SNOWY_PROB) {
    return SNOWY;
  } else if (r < SUNNY_PROB + RAINY_PROB + SNOWY_PROB + WINDY_PROB) {
    return WINDY;
  } else {
    return FOGGY;
  }
}

// Get a random temperature
int get_random_temperature() {
  return MIN_TEMP + (rand() % (MAX_TEMP - MIN_TEMP + 1));
}

// Print the weather forecast
void print_weather_forecast(int weather_type, int temperature) {
  switch (weather_type) {
    case SUNNY:
      printf("The weather forecast for today is sunny with a temperature of %d degrees.\n", temperature);
      break;
    case RAINY:
      printf("The weather forecast for today is rainy with a temperature of %d degrees.\n", temperature);
      break;
    case SNOWY:
      printf("The weather forecast for today is snowy with a temperature of %d degrees.\n", temperature);
      break;
    case WINDY:
      printf("The weather forecast for today is windy with a temperature of %d degrees.\n", temperature);
      break;
    case FOGGY:
      printf("The weather forecast for today is foggy with a temperature of %d degrees.\n", temperature);
      break;
  }
}

// Main function
int main() {
  // Initialize the random number generator
  srand(time(NULL));

  // Get a random weather type
  int weather_type = get_random_weather_type();

  // Get a random temperature
  int temperature = get_random_temperature();

  // Print the weather forecast
  print_weather_forecast(weather_type, temperature);

  return 0;
}