//MISTRAL-7B DATASET v1.0 Category: Temperature monitor ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>

#define I2C_ADDR 0x27 // address of temperature sensor

struct i2c_data {
    int temp;
    int flag;
};

int read_temp(int file_desc) {
    struct i2c_data temp_data;
    if (ioctl(file_desc, I2C_RDWR, (char *)&temp_data) < 0) {
        perror("Error reading from sensor");
        exit(1);
    }
    return temp_data.temp;
}

void print_temp(int temp) {
    printf("\nCurrent temperature: %.2f°C\n", (float)temp / 1000.0);
}

int main() {
    int i, file_desc;
    int temperature[10];

    if ((file_desc = open("/dev/i2c-1", O_RDWR)) < 0) {
        perror("Failed to open the i2c bus.");
        exit(1);
    }

    if (ioctl(file_desc, I2C_SLAVE, I2C_ADDR) < 0) {
        perror("Failed to connect to temperature sensor.");
        exit(1);
    }

    for (i = 0; i < 10; i++) {
        usleep(500000); // wait for 0.5s between readings
        temperature[i] = read_temp(file_desc);
    }

    close(file_desc);

    printf("Temperature readings:\n");
    for (i = 0; i < 10; i++) {
        print_temp(temperature[i]);
    }

    double avg_temp = 0.0;
    for (i = 0; i < 10; i++) {
        avg_temp += temperature[i];
    }
    avg_temp /= 10.0;

    printf("\nAverage temperature: %.2f°C\n", avg_temp);

    return 0;
}