//Falcon-180B DATASET v1.0 Category: Fitness Tracker ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define MAX_EXERCISES 10
#define MAX_WORKOUTS 100
#define MAX_WORKOUT_DURATION 60

typedef struct {
    char name[50];
    int duration;
    int calories;
} Exercise;

typedef struct {
    Exercise exercises[MAX_EXERCISES];
    int num_exercises;
} Workout;

Workout create_workout() {
    Workout w;
    w.num_exercises = 0;
    return w;
}

void add_exercise(Workout *w, char *name, int duration, int calories) {
    if (w->num_exercises >= MAX_EXERCISES) {
        printf("Error: Workout is full.\n");
        return;
    }
    strcpy(w->exercises[w->num_exercises].name, name);
    w->exercises[w->num_exercises].duration = duration;
    w->exercises[w->num_exercises].calories = calories;
    w->num_exercises++;
}

void start_workout(Workout *w, int duration) {
    if (w->num_exercises == 0) {
        printf("Error: Workout has no exercises.\n");
        return;
    }
    printf("Starting workout:\n");
    for (int i = 0; i < w->num_exercises; i++) {
        printf("- %s (%d min, %d cal)\n", w->exercises[i].name, w->exercises[i].duration, w->exercises[i].calories);
    }
    printf("Total duration: %d min\n", duration);
    printf("Total calories burned: %d\n", (duration * w->exercises[0].calories) / w->exercises[0].duration);
}

int main() {
    Workout workout = create_workout();
    add_exercise(&workout, "Running", 30, 300);
    add_exercise(&workout, "Swimming", 45, 500);
    start_workout(&workout, 60);
    return 0;
}