//Falcon2-11B DATASET v1.0 Category: Bucket Sort Implementation ; Style: immersive
#include <stdio.h>
#include <stdlib.h>

// Function to get the size of an array
int getSize(int arr[], int n)
{
    int i;
    int size = 0;

    for (i = 0; i < n; i++)
        size++;

    return size;
}

// Function to perform bucket sort
void bucketSort(int arr[], int n)
{
    // Calculate the number of buckets
    int i, j, k, bucket_size, max_val, min_val, temp;
    int buckets[100] = {0};

    // Initialize max_val and min_val
    max_val = arr[0];
    min_val = arr[0];

    // Traverse the array and update max_val and min_val
    for (i = 0; i < n; i++)
    {
        if (arr[i] > max_val)
            max_val = arr[i];
        if (arr[i] < min_val)
            min_val = arr[i];
    }

    // Calculate the number of buckets
    bucket_size = (max_val - min_val + 1);

    // Traverse the array and put elements into buckets
    for (i = 0; i < n; i++)
    {
        temp = arr[i];
        k = (temp - min_val) / bucket_size;
        j = (temp - min_val) % bucket_size;
        buckets[j]++;
    }

    // Traverse the buckets and put elements in correct order
    for (i = 0; i < bucket_size; i++)
    {
        for (j = 0; j < buckets[i]; j++)
        {
            arr[i] = j + min_val;
        }
    }
}

// Driver Code
int main()
{
    int arr[] = {5, 3, 2, 9, 1, 7, 8, 4, 6};
    int n = sizeof(arr) / sizeof(arr[0]);
    bucketSort(arr, n);
    printf("Sorted array: ");
    for (int i = 0; i < n; i++)
    {
        printf("%d ", arr[i]);
    }
    return 0;
}