//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define MAX_STOCKS 100
#define MAX_NAME_LENGTH 20
#define MAX_SYMBOL_LENGTH 10

typedef struct {
    char name[MAX_NAME_LENGTH];
    char symbol[MAX_SYMBOL_LENGTH];
    double price;
    int volume;
    time_t last_updated;
} Stock;

int num_stocks = 0;
Stock stocks[MAX_STOCKS];

void add_stock(char* name, char* symbol, double price, int volume) {
    if (num_stocks >= MAX_STOCKS) {
        printf("Error: cannot add more than %d stocks\n", MAX_STOCKS);
        return;
    }
    
    strcpy(stocks[num_stocks].name, name);
    strcpy(stocks[num_stocks].symbol, symbol);
    stocks[num_stocks].price = price;
    stocks[num_stocks].volume = volume;
    stocks[num_stocks].last_updated = time(NULL);
    
    num_stocks++;
}

void update_stock(char* symbol, double price, int volume) {
    int i;
    for (i = 0; i < num_stocks; i++) {
        if (strcmp(stocks[i].symbol, symbol) == 0) {
            stocks[i].price = price;
            stocks[i].volume = volume;
            stocks[i].last_updated = time(NULL);
            return;
        }
    }
    
    printf("Error: stock not found\n");
}

void print_stocks() {
    int i;
    for (i = 0; i < num_stocks; i++) {
        printf("%s (%s) - $%.2f - %d shares - Last updated: %s\n", stocks[i].name, stocks[i].symbol, stocks[i].price, stocks[i].volume, ctime(&stocks[i].last_updated));
    }
}

int main() {
    add_stock("Apple Inc.", "AAPL", 150.00, 100000);
    add_stock("Microsoft Corporation", "MSFT", 200.00, 50000);
    add_stock("Amazon.com Inc.", "AMZN", 3000.00, 2000);
    
    print_stocks();
    
    update_stock("AAPL", 160.00, 80000);
    
    print_stocks();
    
    return 0;
}