//Falcon2-11B DATASET v1.0 Category: Website Uptime Monitor ; Style: systematic
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <errno.h>

#define PORT 80
#define TIMEOUT 5

int main() {
    int sockfd, n;
    struct sockaddr_in servaddr;
    struct timeval timeout;
    char buffer[1024];
    int status = 0;

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("ERROR opening socket");
        exit(1);
    }

    bzero((char *) &servaddr, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(PORT);
    if (inet_pton(AF_INET, "127.0.0.1", &servaddr.sin_addr) <= 0) {
        perror("ERROR, can't resolve the host name");
        exit(1);
    }

    timeout.tv_sec = TIMEOUT;
    timeout.tv_usec = 0;

    setsockopt(sockfd, SOL_SOCKET, SO_RCVTIMEO, (char *)&timeout, sizeof(timeout));

    if (connect(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0) {
        perror("ERROR connecting");
        exit(1);
    }

    printf("Establishing connection with server...\n");
    printf("Sending GET request...\n");
    n = write(sockfd, "GET / HTTP/1.1\r\nHost: 127.0.0.1\r\nConnection: close\r\n\r\n", 66);
    if (n < 0) {
        perror("ERROR writing to socket");
        exit(1);
    }

    printf("Waiting for response...\n");
    memset(buffer, 0, sizeof(buffer));
    n = read(sockfd, buffer, sizeof(buffer));
    if (n < 0) {
        perror("ERROR reading from socket");
        exit(1);
    }

    printf("Response received: %s\n", buffer);
    printf("Status code: %d\n", status);

    return 0;
}