//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESS 5

struct process
{
    int pid;
    int arrival_time;
    int burst_time;
    int waiting_time;
    int turn_around_time;
};

void calculate_waiting_time(struct process *processes)
{
    processes->waiting_time = 0;
    for (int i = 0; i < MAX_PROCESS; i++)
    {
        processes[i].waiting_time = processes[i].arrival_time - processes[i].burst_time;
    }
}

void calculate_turn_around_time(struct process *processes)
{
    processes->turn_around_time = 0;
    for (int i = 0; i < MAX_PROCESS; i++)
    {
        processes[i].turn_around_time = processes[i].waiting_time + processes[i].burst_time;
    }
}

void print_processes(struct process *processes)
{
    printf("Process ID\tArrival Time\tBurst Time\tWaiting Time\tTurnaround Time\n");
    for (int i = 0; i < MAX_PROCESS; i++)
    {
        printf("%d\t\t%d\t\t%d\t\t%d\t\t%d\n", processes[i].pid, processes[i].arrival_time, processes[i].burst_time, processes[i].waiting_time, processes[i].turn_around_time);
    }
}

int main()
{
    struct process processes[MAX_PROCESS];

    // Create processes
    processes[0].pid = 1;
    processes[0].arrival_time = 0;
    processes[0].burst_time = 5;

    processes[1].pid = 2;
    processes[1].arrival_time = 2;
    processes[1].burst_time = 3;

    processes[2].pid = 3;
    processes[2].arrival_time = 3;
    processes[2].burst_time = 4;

    processes[3].pid = 4;
    processes[3].arrival_time = 4;
    processes[3].burst_time = 2;

    processes[4].pid = 5;
    processes[4].arrival_time = 5;
    processes[4].burst_time = 6;

    // Calculate waiting time and turn around time
    calculate_waiting_time(processes);
    calculate_turn_around_time(processes);

    // Print processes
    print_processes(processes);

    return 0;
}