//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STOCKS 100
#define MAX_NAME_LEN 20

// Structure to hold stock information
typedef struct {
    char name[MAX_NAME_LEN];
    double price;
    int quantity;
} Stock;

// Function to add a new stock to the portfolio
void add_stock(Stock portfolio[], int num_stocks, char* name, double price, int quantity) {
    if (num_stocks >= MAX_STOCKS) {
        printf("Error: Portfolio is full.\n");
        return;
    }

    strncpy(portfolio[num_stocks].name, name, MAX_NAME_LEN);
    portfolio[num_stocks].price = price;
    portfolio[num_stocks].quantity = quantity;

    num_stocks++;
}

// Function to sell a stock from the portfolio
void sell_stock(Stock portfolio[], int num_stocks, char* name) {
    int i;

    for (i = 0; i < num_stocks; i++) {
        if (strcmp(portfolio[i].name, name) == 0) {
            portfolio[i].quantity -= 1;
            printf("Sold 1 share of %s.\n", name);
            return;
        }
    }

    printf("Error: Stock not found.\n");
}

// Function to display the current portfolio
void display_portfolio(Stock portfolio[], int num_stocks) {
    int i;

    for (i = 0; i < num_stocks; i++) {
        printf("%-20s $%.2f %d\n", portfolio[i].name, portfolio[i].price, portfolio[i].quantity);
    }
}

int main() {
    Stock portfolio[MAX_STOCKS];
    int num_stocks = 0;

    // Initialize portfolio with some stocks
    add_stock(portfolio, num_stocks, "AAPL", 150.00, 100);
    add_stock(portfolio, num_stocks, "GOOG", 1200.00, 50);
    add_stock(portfolio, num_stocks, "MSFT", 110.00, 200);

    display_portfolio(portfolio, num_stocks);

    // Sell some stocks
    sell_stock(portfolio, num_stocks, "AAPL");
    sell_stock(portfolio, num_stocks, "GOOG");

    display_portfolio(portfolio, num_stocks);

    return 0;
}