//GPT-4o-mini DATASET v1.0 Category: Educational ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_USERS 10
#define MAX_NAME_LENGTH 50

typedef struct User {
    char name[MAX_NAME_LENGTH];
    int age;
    int surprised; // 1 if shocked, 0 if normal
} User;

// Function to generate a random integer within a range
int randomRange(int min, int max) {
    return rand() % (max - min + 1) + min;
}

// Function to create random users
void createUsers(User users[], int count) {
    const char *names[] = {"Alice", "Bob", "Charlie", "Diana", "Evan", 
                           "Fiona", "George", "Hannah", "Iris", "Jason"};
    
    for (int i = 0; i < count; i++) {
        strcpy(users[i].name, names[i]);
        users[i].age = randomRange(18, 60);
        users[i].surprised = 0;  // Initialize to normal state
        printf("User Created: Name: %s, Age: %d\n", users[i].name, users[i].age);
    }
}

// Function to simulate a surprise event for users
void surpriseUsers(User users[], int count) {
    printf("\nSurprise Event Initiated! Brace yourselves...\n\n");
    
    for (int i = 0; i < count; i++) {
        users[i].surprised = 1; // Set shocked state
        printf("%s is shocked! 😱 (Age: %d)\n", users[i].name, users[i].age);
    }
}

// Function to reset users to normal state
void resetUsers(User users[], int count) {
    printf("\nResetting users from shocked state...\n");
    
    for (int i = 0; i < count; i++) {
        users[i].surprised = 0; // Set back to normal
        printf("%s is back to normal. 😊 (Age: %d)\n", users[i].name, users[i].age);
    }
}

// Function to display the state of each user
void displayUserStates(User users[], int count) {
    printf("\nCurrent States of Users:\n");
    
    for (int i = 0; i < count; i++) {
        printf("User: %s, Age: %d, State: %s\n", 
                users[i].name, 
                users[i].age, 
                users[i].surprised ? "Shocked" : "Normal");
    }
}

// Main function
int main() {
    // Seed the random number generator
    srand(time(NULL));

    User users[MAX_USERS];
    
    // Create users
    createUsers(users, MAX_USERS);
    
    // Display initial state
    displayUserStates(users, MAX_USERS);
    
    // Surprise the users
    surpriseUsers(users, MAX_USERS);
    
    // Display state after surprise
    displayUserStates(users, MAX_USERS);
    
    // Reset users to normal state
    resetUsers(users, MAX_USERS);
    
    // Display final state
    displayUserStates(users, MAX_USERS);
    
    return 0;
}