//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: active
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESSES 5

struct Process {
    int arrival_time;
    int burst_time;
};

struct Process processes[MAX_PROCESSES] = {
    {0, 5},
    {1, 2},
    {2, 6},
    {3, 1},
    {4, 4}
};

int main() {
    int current_time = 0;
    int completed_processes = 0;
    int waiting_time = 0;
    int turnaround_time = 0;

    while (completed_processes < MAX_PROCESSES) {
        int shortest_burst_time = -1;
        int shortest_burst_time_index = -1;

        for (int i = 0; i < MAX_PROCESSES; i++) {
            if (processes[i].arrival_time <= current_time && processes[i].burst_time > 0) {
                if (shortest_burst_time == -1 || processes[i].burst_time < shortest_burst_time) {
                    shortest_burst_time = processes[i].burst_time;
                    shortest_burst_time_index = i;
                }
            }
        }

        if (shortest_burst_time_index == -1) {
            current_time++;
            continue;
        }

        current_time += shortest_burst_time;
        waiting_time += current_time - processes[shortest_burst_time_index].arrival_time - processes[shortest_burst_time_index].burst_time;
        turnaround_time += current_time - processes[shortest_burst_time_index].arrival_time;
        completed_processes++;

        processes[shortest_burst_time_index].burst_time = 0;
    }

    printf("Average waiting time: %f\n", (float) waiting_time / MAX_PROCESSES);
    printf("Average turnaround time: %f\n", (float) turnaround_time / MAX_PROCESSES);

    return 0;
}