//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: complete
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESS 5
#define Quantum 4

typedef struct process {
    int pid;
    char name[20];
    int arrivalTime;
    int burstTime;
    int remainingTime;
} process;

void preemptive_round_robin(process* processes) {
    int time = 0;
    int currentProcess = 0;
    int i = 0;

    while (!processes[currentProcess].remainingTime && i < MAX_PROCESS) {
        time++;
        processes[currentProcess].remainingTime--;

        if (processes[currentProcess].remainingTime == 0) {
            currentProcess = (currentProcess + 1) % MAX_PROCESS;
        }

        i++;
    }

    printf("Time: %d\n", time);
    printf("Process completed:\n");
    for (i = 0; i < MAX_PROCESS; i++) {
        if (processes[i].remainingTime == 0) {
            printf("%s completed\n", processes[i].name);
        }
    }
}

int main() {
    process processes[MAX_PROCESS];

    // Create processes
    processes[0].pid = 1;
    strcpy(processes[0].name, "Process A");
    processes[0].arrivalTime = 0;
    processes[0].burstTime = 5;
    processes[0].remainingTime = processes[0].burstTime;

    processes[1].pid = 2;
    strcpy(processes[1].name, "Process B");
    processes[1].arrivalTime = 2;
    processes[1].burstTime = 4;
    processes[1].remainingTime = processes[1].burstTime;

    processes[2].pid = 3;
    strcpy(processes[2].name, "Process C");
    processes[2].arrivalTime = 3;
    processes[2].burstTime = 3;
    processes[2].remainingTime = processes[2].burstTime;

    processes[3].pid = 4;
    strcpy(processes[3].name, "Process D");
    processes[3].arrivalTime = 4;
    processes[3].burstTime = 2;
    processes[3].remainingTime = processes[3].burstTime;

    processes[4].pid = 5;
    strcpy(processes[4].name, "Process E");
    processes[4].arrivalTime = 5;
    processes[4].burstTime = 1;
    processes[4].remainingTime = processes[4].burstTime;

    preemptive_round_robin(processes);

    return 0;
}