//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: Linus Torvalds
#include <stdio.h>
#include <stdint.h>

// Bitwise OR operation
uint32_t bitwise_or(uint32_t a, uint32_t b)
{
    return a | b;
}

// Bitwise AND operation
uint32_t bitwise_and(uint32_t a, uint32_t b)
{
    return a & b;
}

// Bitwise XOR operation
uint32_t bitwise_xor(uint32_t a, uint32_t b)
{
    return a ^ b;
}

// Bitwise NOT operation
uint32_t bitwise_not(uint32_t a)
{
    return ~a;
}

// Bitwise left shift operation
uint32_t bitwise_left_shift(uint32_t a, uint32_t b)
{
    return a << b;
}

// Bitwise right shift operation
uint32_t bitwise_right_shift(uint32_t a, uint32_t b)
{
    return a >> b;
}

int main()
{
    uint32_t num1 = 0x12345678;
    uint32_t num2 = 0x87654321;

    // Bitwise OR operation
    uint32_t result_or = bitwise_or(num1, num2);
    printf("Bitwise OR result: 0x%08X\n", result_or);

    // Bitwise AND operation
    uint32_t result_and = bitwise_and(num1, num2);
    printf("Bitwise AND result: 0x%08X\n", result_and);

    // Bitwise XOR operation
    uint32_t result_xor = bitwise_xor(num1, num2);
    printf("Bitwise XOR result: 0x%08X\n", result_xor);

    // Bitwise NOT operation
    uint32_t result_not = bitwise_not(num1);
    printf("Bitwise NOT result: 0x%08X\n", result_not);

    // Bitwise left shift operation
    uint32_t result_left_shift = bitwise_left_shift(num1, 4);
    printf("Bitwise left shift result: 0x%08X\n", result_left_shift);

    // Bitwise right shift operation
    uint32_t result_right_shift = bitwise_right_shift(num1, 4);
    printf("Bitwise right shift result: 0x%08X\n", result_right_shift);

    return 0;
}