//GPT-4o-mini DATASET v1.0 Category: Rogue-like Game with Procedural Generation ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_ROOMS 10
#define MAX_CLUES 5

typedef struct {
    char description[50];
    int clueCount;
    char clues[MAX_CLUES][50];
} Room;

typedef struct {
    Room rooms[MAX_ROOMS];
    int roomCount;
} Game;

void initializeGame(Game *game) {
    srand(time(NULL));
    game->roomCount = 0;

    char *descriptions[] = {
        "The dusty library filled with ancient tomes",
        "A dark alley shrouded in fog",
        "The elegant drawing room with a grand piano",
        "A dimly lit study cluttered with papers",
        "The grimy bakery where stolen goods may hide"
    };

    for (int i = 0; i < MAX_ROOMS; i++) {
        strcpy(game->rooms[i].description, descriptions[rand() % 5]);
        game->rooms[i].clueCount = rand() % (MAX_CLUES + 1);
        
        for (int j = 0; j < game->rooms[i].clueCount; j++) {
            sprintf(game->rooms[i].clues[j], "Clue %d in %s", j + 1, game->rooms[i].description);
        }
    }
    game->roomCount = MAX_ROOMS;
}

void printRooms(Game *game) {
    printf("You find yourself in the following mysterious rooms:\n");
    for (int i = 0; i < game->roomCount; i++) {
        printf("%d. %s\n", i + 1, game->rooms[i].description);
    }
}

void investigateRoom(Game *game, int roomIndex) {
    if (roomIndex < 0 || roomIndex >= game->roomCount) {
        printf("Invalid room index.\n");
        return;
    }

    Room room = game->rooms[roomIndex];
    printf("You are investigating: %s\n", room.description);
    
    if (room.clueCount == 0) {
        printf("No clues found in this room.\n");
    } else {
        printf("You found the following clues:\n");
        for (int j = 0; j < room.clueCount; j++) {
            printf("- %s\n", room.clues[j]);
        }
    }
}

int main() {
    Game game;
    initializeGame(&game);
    
    printRooms(&game);

    while (1) {
        int choice;
        printf("Select a room to investigate (1 to %d) or 0 to exit: ", game.roomCount);
        scanf("%d", &choice);
        
        if (choice == 0) {
            printf("Exiting the game. Happy sleuthing!\n");
            break;
        }
        
        investigateRoom(&game, choice - 1);
    }

    return 0;
}