//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: configurable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 1000
#define MAX_VOTER_NAME_LENGTH 50

typedef struct {
    char name[MAX_VOTER_NAME_LENGTH];
    int voterID;
} Voter;

typedef struct {
    char name[MAX_VOTER_NAME_LENGTH];
    int votes;
} Candidate;

Voter voters[MAX_VOTERS];
Candidate candidates[MAX_CANDIDATES];

int numVoters = 0;
int numCandidates = 0;

void registerVoter(char* name) {
    if (numVoters >= MAX_VOTERS) {
        printf("Error: Maximum number of voters reached.\n");
        return;
    }

    strcpy(voters[numVoters].name, name);
    voters[numVoters].voterID = numVoters + 1;
    numVoters++;
}

void registerCandidate(char* name) {
    if (numCandidates >= MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached.\n");
        return;
    }

    strcpy(candidates[numCandidates].name, name);
    candidates[numCandidates].votes = 0;
    numCandidates++;
}

void vote(int voterID, int candidateID) {
    for (int i = 0; i < numVoters; i++) {
        if (voters[i].voterID == voterID) {
            for (int j = 0; j < numCandidates; j++) {
                if (candidates[j].votes == candidateID) {
                    candidates[j].votes++;
                    break;
                }
            }
            break;
        }
    }
}

void displayResults() {
    printf("Election Results:\n");
    for (int i = 0; i < numCandidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    registerVoter("Alice");
    registerVoter("Bob");
    registerVoter("Charlie");

    registerCandidate("Alice");
    registerCandidate("Bob");
    registerCandidate("Charlie");

    vote(1, 1);
    vote(2, 2);
    vote(3, 1);

    displayResults();

    return 0;
}