//GEMINI-pro DATASET v1.0 Category: Banking Record System ; Style: Romeo and Juliet
// A tale of woe and banking woe

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define our star-crossed lovers
typedef struct {
  char *name;
  int account_number;
  double balance;
} customer;

// The Montagues and Capulets (our banks)
customer montagues[] = {
  { .name = "Romeo", .account_number = 12345, .balance = 1000 },
  { .name = "Juliet", .account_number = 67890, .balance = 1500 },
};

customer capulets[] = {
  { .name = "Tybalt", .account_number = 98765, .balance = 2000 },
  { .name = "Lady Capulet", .account_number = 45678, .balance = 2500 },
};

// The prince (our program)
int main(void) {
  // Set the tragic scene
  printf("Wherefore art thou, Romeo?\n");
  printf("And Juliet, fair maid, where art thou?\n");

  // Find our lovers' accounts
  customer *romeo = NULL;
  customer *juliet = NULL;
  for (int i = 0; i < sizeof(montagues) / sizeof(montagues[0]); i++) {
    if (strcmp(montagues[i].name, "Romeo") == 0) {
      romeo = &montagues[i];
    }
  }
  for (int i = 0; i < sizeof(capulets) / sizeof(capulets[0]); i++) {
    if (strcmp(capulets[i].name, "Juliet") == 0) {
      juliet = &capulets[i];
    }
  }

  // If our lovers were not found, tragedy strikes
  if (romeo == NULL || juliet == NULL) {
    printf("Alas, our lovers be not found!\n");
    return EXIT_FAILURE;
  }

  // Display their tragic tale
  printf("Romeo of House Montague, with account %d and balance %.2f\n", romeo->account_number, romeo->balance);
  printf("Juliet of House Capulet, with account %d and balance %.2f\n", juliet->account_number, juliet->balance);

  // Now, let's transfer some funds
  double transfer_amount = 100;
  printf("\nRomeo wishes to transfer %.2f to Juliet's account.\n", transfer_amount);

  // Check if Romeo has enough funds
  if (romeo->balance < transfer_amount) {
    printf("Romeo hath not enough funds to make this transfer.\n");
    return EXIT_FAILURE;
  }

  // Transfer the funds
  romeo->balance -= transfer_amount;
  juliet->balance += transfer_amount;

  // Display the updated balances
  printf("\nAfter the transfer:\n");
  printf("Romeo's balance is now %.2f\n", romeo->balance);
  printf("Juliet's balance is now %.2f\n", juliet->balance);

  // Alas, their love was forbidden
  printf("\nBut alas, their love was forbidden.\n");
  printf("And so, their accounts were frozen, and their funds forever lost.\n");

  return EXIT_SUCCESS;
}