//Gemma-7B DATASET v1.0 Category: Space Invaders Game Clone ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define LEFT 0
#define RIGHT 1
#define UP 2
#define DOWN 3

#define GRID_SIZE 10
#define invader_SIZE 5

typedef struct invader {
    int x;
    int y;
    int direction;
} invader_t;

invader_t invaders[invader_SIZE];

void initialize_invaders() {
    for (int i = 0; i < invader_SIZE; i++) {
        invaders[i].x = i;
        invaders[i].y = 0;
        invaders[i].direction = RIGHT;
    }
}

void move_invaders() {
    for (int i = 0; i < invader_SIZE; i++) {
        switch (invaders[i].direction) {
            case LEFT:
                invaders[i].x--;
                break;
            case RIGHT:
                invaders[i].x++;
                break;
            case UP:
                invaders[i].y--;
                break;
            case DOWN:
                invaders[i].y++;
                break;
        }

        if (invaders[i].x >= GRID_SIZE - 1) {
            invaders[i].direction = LEFT;
        } else if (invaders[i].x <= 0) {
            invaders[i].direction = RIGHT;
        }

        if (invaders[i].y >= GRID_SIZE - 1) {
            invaders[i].direction = UP;
        } else if (invaders[i].y <= 0) {
            invaders[i].direction = DOWN;
        }
    }
}

void draw_invaders() {
    for (int i = 0; i < invader_SIZE; i++) {
        printf("%c", invaders[i].x + 1);
    }

    printf("\n");
}

int main() {
    initialize_invaders();

    for (int i = 0; i < 10; i++) {
        move_invaders();
        draw_invaders();
    }

    return 0;
}