//Falcon-180B DATASET v1.0 Category: Phone Book ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define MAX_NAME_LENGTH 50
#define MAX_NUMBER_LENGTH 20
#define MAX_ENTRIES 1000

// Define the structure of a phone book entry
typedef struct {
    char name[MAX_NAME_LENGTH];
    char number[MAX_NUMBER_LENGTH];
} phonebook_entry;

// Define the phone book itself
phonebook_entry phonebook[MAX_ENTRIES];
int num_entries = 0;

// Function to add an entry to the phone book
void add_entry(char* name, char* number) {
    strcpy(phonebook[num_entries].name, name);
    strcpy(phonebook[num_entries].number, number);
    num_entries++;
}

// Function to search for an entry in the phone book by name
int search_by_name(char* name) {
    int i;
    for (i = 0; i < num_entries; i++) {
        if (strcmp(phonebook[i].name, name) == 0) {
            return i;
        }
    }
    return -1;
}

// Function to search for an entry in the phone book by number
int search_by_number(char* number) {
    int i;
    for (i = 0; i < num_entries; i++) {
        if (strcmp(phonebook[i].number, number) == 0) {
            return i;
        }
    }
    return -1;
}

// Function to print the entire phone book
void print_phonebook() {
    int i;
    for (i = 0; i < num_entries; i++) {
        printf("%s: %s\n", phonebook[i].name, phonebook[i].number);
    }
}

int main() {
    // Add some entries to the phone book
    add_entry("John Doe", "555-1234");
    add_entry("Jane Doe", "555-5678");
    add_entry("Bob Smith", "555-9876");

    // Print the entire phone book
    print_phonebook();

    // Search for an entry by name
    int index = search_by_name("Jane Doe");
    if (index!= -1) {
        printf("Found Jane Doe at index %d\n", index);
    } else {
        printf("Jane Doe not found\n");
    }

    // Search for an entry by number
    index = search_by_number("555-5678");
    if (index!= -1) {
        printf("Found 555-5678 at index %d\n", index);
    } else {
        printf("555-5678 not found\n");
    }

    return 0;
}