//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

typedef struct {
    char name[50];
    int votes;
} candidate;

typedef struct {
    char name[50];
    int voter_id;
} voter;

candidate candidates[MAX_CANDIDATES];
voter voters[MAX_VOTERS];

int num_candidates = 0;
int num_voters = 0;

void add_candidate(char* name) {
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(char* name) {
    strcpy(voters[num_voters].name, name);
    voters[num_voters].voter_id = num_voters + 1;
    num_voters++;
}

int authenticate_voter(char* name) {
    for (int i = 0; i < num_voters; i++) {
        if (strcmp(name, voters[i].name) == 0) {
            return voters[i].voter_id;
        }
    }
    return -1;
}

int vote(int voter_id, int candidate_id) {
    if (candidate_id >= 0 && candidate_id < num_candidates) {
        candidates[candidate_id].votes++;
        return 1;
    }
    return 0;
}

void print_results() {
    for (int i = 0; i < num_candidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    add_candidate("Alice");
    add_candidate("Bob");
    add_candidate("Charlie");

    add_voter("Alice");
    add_voter("Bob");
    add_voter("Charlie");

    int voter_id = authenticate_voter("Alice");
    if (voter_id!= -1) {
        vote(voter_id, 0);
        vote(voter_id, 1);
    }

    voter_id = authenticate_voter("Bob");
    if (voter_id!= -1) {
        vote(voter_id, 0);
        vote(voter_id, 1);
        vote(voter_id, 2);
    }

    voter_id = authenticate_voter("Charlie");
    if (voter_id!= -1) {
        vote(voter_id, 1);
        vote(voter_id, 2);
    }

    print_results();

    return 0;
}