//Falcon-180B DATASET v1.0 Category: Memory Game ; Style: beginner-friendly
#include<stdio.h>
#include<stdlib.h>
#include<time.h>

#define ROWS 4
#define COLS 4

void initBoard(char board[ROWS][COLS])
{
    int i,j;
    for(i=0;i<ROWS;i++)
    {
        for(j=0;j<COLS;j++)
        {
            board[i][j] = '*';
        }
    }
}

int checkWin(char board[ROWS][COLS])
{
    int i,j;
    for(i=0;i<ROWS;i++)
    {
        if(board[i][0] == board[i][1] && board[i][1] == board[i][2] && board[i][2] == board[i][3])
        {
            return 1;
        }
        if(board[0][i] == board[1][i] && board[1][i] == board[2][i] && board[2][i] == board[3][i])
        {
            return 1;
        }
    }
    if(board[0][0] == board[1][1] && board[1][1] == board[2][2] && board[2][2] == board[3][3])
    {
        return 1;
    }
    if(board[0][3] == board[1][2] && board[1][2] == board[2][1] && board[2][1] == board[3][0])
    {
        return 1;
    }
    return 0;
}

void printBoard(char board[ROWS][COLS])
{
    int i,j;
    for(i=0;i<ROWS;i++)
    {
        for(j=0;j<COLS;j++)
        {
            printf("%c ",board[i][j]);
        }
        printf("\n");
    }
}

int main()
{
    srand(time(NULL));
    char board[ROWS][COLS];
    int player = 0;
    initBoard(board);
    while(1)
    {
        system("clear");
        printBoard(board);
        int x,y;
        if(player % 2 == 0)
        {
            x = rand() % ROWS;
            y = rand() % COLS;
            while(board[x][y]!= '*')
            {
                x = rand() % ROWS;
                y = rand() % COLS;
            }
            board[x][y] = 'X';
            player++;
        }
        else
        {
            printf("Player %d's turn\n",player/2+1);
            scanf("%d %d",&x,&y);
            while(board[x][y]!= '*')
            {
                printf("Invalid move. Try again.\n");
                scanf("%d %d",&x,&y);
            }
            board[x][y] = 'O';
            player++;
        }
        if(checkWin(board))
        {
            printf("Player %d wins!\n",player/2+1);
            break;
        }
        if(player == 16)
        {
            printf("It's a tie.\n");
            break;
        }
    }
    return 0;
}