//Gemma-7B DATASET v1.0 Category: Stock market tracker ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_STOCK_NUM 10
#define MAX_STOCK_NAME_LEN 20

typedef struct Stock
{
    char name[MAX_STOCK_NAME_LEN];
    double current_price;
    double previous_price;
    double change_percentage;
} Stock;

Stock stocks[MAX_STOCK_NUM] = {
    {"Waterford Pharmaceuticals", 100.25, 102.50, -2.25},
    {"The Green Corporation", 88.12, 87.25, 0.87},
    {"Solar Technologies", 92.34, 90.00, 2.34},
    {"Cyberdyne Systems", 76.50, 74.80, 1.70},
    {"Advanced Robotics", 82.43, 80.00, 2.43},
    {"New Frontier Technologies", 94.21, 92.00, 2.21},
    {"Quantum Systems", 86.15, 84.00, 2.15},
    {"BioTech Industries", 98.00, 96.25, 1.75},
    {"Advanced Energy Corporation", 80.32, 78.50, 1.82},
    {"Fusion Dynamics", 84.21, 82.00, 2.21}
};

void calculate_stock_changes(void)
{
    for (int i = 0; i < MAX_STOCK_NUM; i++)
    {
        stocks[i].change_percentage = (stocks[i].current_price - stocks[i].previous_price) / stocks[i].previous_price * 100.0;
    }
}

void display_stock_list(void)
{
    printf("------------------------------------------------------------------------\n");
    printf("           STOCK LIST\n");
    printf("------------------------------------------------------------------------\n");

    for (int i = 0; i < MAX_STOCK_NUM; i++)
    {
        printf("Name: %s\n", stocks[i].name);
        printf("Current Price: $%.2lf\n", stocks[i].current_price);
        printf("Previous Price: $%.2lf\n", stocks[i].previous_price);
        printf("Change Percentage: %.2lf%\n", stocks[i].change_percentage);
        printf("------------------------------------------------------------------------\n");
    }
}

int main(void)
{
    calculate_stock_changes();
    display_stock_list();

    return 0;
}