//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define WIDTH 16
#define HEIGHT 8

// Function to create a 2D pixel art representation of a medieval shield
void createShield(char art[HEIGHT][WIDTH]) {
    // Fill background with spaces
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            art[i][j] = ' ';
        }
    }

    // Draw the shield structure
    for (int i = 3; i < 7; i++) {
        for (int j = 4; j < 12; j++) {
            art[i][j] = '#'; // Shield outline
        }
    }

    // Draw the inner design
    art[5][6] = '*'; art[5][7] = '*'; art[5][8] = '*'; // Three stars
    art[5][10] = '*'; 
        
    // Draw additional patterns
    art[3][5] = '^'; art[3][12] = '^'; // Top spikes
    art[6][5] = 'v'; art[6][12] = 'v'; // Bottom spikes
}

// Function to display the pixel art
void displayArt(char art[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            putchar(art[i][j]);
        }
        putchar('\n');
    }
}

// Function to create a 2D pixel art representation of a medieval sword
void createSword(char art[HEIGHT][WIDTH]) {
    // Fill background with spaces
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            art[i][j] = ' ';
        }
    }

    // Draw blade
    for (int i = 0; i < 5; i++) {
        art[i][8] = '|'; // Sword blade
    }

    // Draw hilt
    art[5][6] = '---'; // Hilt of the sword
    art[5][7] = '|'; art[5][8] = '|'; art[5][9] = '|';
    art[5][10] = '---';

    // Draw grip
    art[6][6] = '(';
    art[6][10] = ')';

    // Draw pommel
    art[7][8] = 'O';
}

// Main function
int main() {
    char shieldArt[HEIGHT][WIDTH];
    char swordArt[HEIGHT][WIDTH];

    // Create the pixel art representations
    createShield(shieldArt);
    createSword(swordArt);

    // Display the medieval shield
    printf("Medieval Shield:\n");
    displayArt(shieldArt);
    
    // Space between images
    printf("\n");

    // Display the medieval sword
    printf("Medieval Sword:\n");
    displayArt(swordArt);

    return 0;
}