//LLAMA2-13B DATASET v1.0 Category: Log analysis ; Style: introspective
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <inttypes.h>

#define MAX_LINE_LEN 1024
#define MAX_DEPTH 5

typedef struct {
    char *file;
    size_t line;
    size_t column;
} location_t;

static void log_message(const char *message, location_t *location) {
    size_t len = strlen(message);
    if (len > MAX_LINE_LEN) {
        len = MAX_LINE_LEN;
    }
    printf("%.*s\n", len, message);
    if (location != NULL) {
        printf("File: %s, Line: %zu, Column: %zu\n", location->file, location->line, location->column);
    }
}

static void log_error(const char *message, location_t *location) {
    log_message(message, location);
    printf("Error: %s\n", message);
}

static void log_warning(const char *message, location_t *location) {
    log_message(message, location);
    printf("Warning: %s\n", message);
}

static void log_info(const char *message, location_t *location) {
    log_message(message, location);
    printf("Info: %s\n", message);
}

int main() {
    char *message = "This is a test message";
    location_t location = { "test.c", 10, 20 };

    log_info(message, &location);
    log_warning(message, &location);
    log_error(message, &location);

    char *message2 = "This is another test message";
    location_t location2 = { "test2.c", 20, 30 };

    log_info(message2, &location2);
    log_error(message2, &location2);

    return 0;
}