//Code Llama-13B DATASET v1.0 Category: Banking Record System ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// Structure to represent a bank account
typedef struct {
  int account_number;
  char* account_holder;
  double balance;
  char* account_type;
  time_t opening_date;
} BankAccount;

// Function to print the details of a bank account
void print_bank_account(BankAccount* account) {
  printf("Account Number: %d\n", account->account_number);
  printf("Account Holder: %s\n", account->account_holder);
  printf("Balance: %f\n", account->balance);
  printf("Account Type: %s\n", account->account_type);
  printf("Opening Date: %s\n", ctime(&account->opening_date));
}

// Function to deposit money into a bank account
void deposit_money(BankAccount* account, double amount) {
  account->balance += amount;
}

// Function to withdraw money from a bank account
void withdraw_money(BankAccount* account, double amount) {
  account->balance -= amount;
}

// Function to transfer money from one bank account to another
void transfer_money(BankAccount* from_account, BankAccount* to_account, double amount) {
  from_account->balance -= amount;
  to_account->balance += amount;
}

// Main function
int main() {
  BankAccount account1;
  BankAccount account2;

  // Initialize the first bank account
  account1.account_number = 123456789;
  account1.account_holder = "John Doe";
  account1.balance = 1000.0;
  account1.account_type = "Savings";
  account1.opening_date = time(NULL);

  // Initialize the second bank account
  account2.account_number = 987654321;
  account2.account_holder = "Jane Doe";
  account2.balance = 500.0;
  account2.account_type = "Current";
  account2.opening_date = time(NULL);

  // Print the details of both bank accounts
  print_bank_account(&account1);
  print_bank_account(&account2);

  // Deposit money into the first bank account
  deposit_money(&account1, 500.0);
  printf("Deposited $500 into account 1\n");

  // Withdraw money from the second bank account
  withdraw_money(&account2, 250.0);
  printf("Withdrew $250 from account 2\n");

  // Transfer money from the first bank account to the second bank account
  transfer_money(&account1, &account2, 200.0);
  printf("Transferred $200 from account 1 to account 2\n");

  // Print the updated balances
  printf("Account 1 Balance: $%f\n", account1.balance);
  printf("Account 2 Balance: $%f\n", account2.balance);

  return 0;
}