//LLAMA2-13B DATASET v1.0 Category: Math exercise ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// Define a struct for a complex number
typedef struct {
    double real;
    double imag;
} complex;

// Define a function to add two complex numbers
complex add_complex(complex a, complex b) {
    complex result;
    result.real = a.real + b.real;
    result.imag = a.imag + b.imag;
    return result;
}

// Define a function to multiply two complex numbers
complex multiply_complex(complex a, complex b) {
    complex result;
    result.real = a.real * b.real - a.imag * b.imag;
    result.imag = 2 * a.real * b.imag + a.imag * b.real;
    return result;
}

// Define a function to calculate the magnitude of a complex number
double magnitude(complex a) {
    return sqrt(a.real * a.real + a.imag * a.imag);
}

// Define a function to calculate the angle of a complex number
double angle(complex a) {
    return atan2(a.imag, a.real);
}

int main() {
    // Declare and initialize two complex numbers
    complex a = {3, 4};
    complex b = {2, 1};

    // Calculate the result of adding the two complex numbers
    complex c = add_complex(a, b);

    // Calculate the result of multiplying the two complex numbers
    complex d = multiply_complex(a, b);

    // Print the magnitude and angle of the result
    printf("Magnitude of c: %f\n", magnitude(c));
    printf("Angle of c: %f\n", angle(c));

    return 0;
}