//Falcon-180B DATASET v1.0 Category: Cafe Billing System ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

typedef struct {
    char name[50];
    int price;
} Item;

typedef struct {
    char name[50];
    int price;
    int quantity;
} Order;

void addItem(Item* menu, int numItems, char* name, int price) {
    if (numItems >= 100) {
        printf("Menu is full!\n");
        return;
    }
    strcpy(menu[numItems].name, name);
    menu[numItems].price = price;
    numItems++;
}

void printMenu(Item* menu, int numItems) {
    printf("Menu:\n");
    for (int i = 0; i < numItems; i++) {
        printf("%d. %s - $%d\n", i+1, menu[i].name, menu[i].price);
    }
}

void addOrder(Order* order, int numOrders, char* name, int price, int quantity) {
    if (numOrders >= 10) {
        printf("Too many orders!\n");
        return;
    }
    strcpy(order[numOrders].name, name);
    order[numOrders].price = price;
    order[numOrders].quantity = quantity;
    numOrders++;
}

void printOrder(Order* order, int numOrders) {
    printf("Order:\n");
    for (int i = 0; i < numOrders; i++) {
        printf("%d. %s - $%d x %d\n", i+1, order[i].name, order[i].price, order[i].quantity);
    }
}

void calculateTotal(Order* order, int numOrders) {
    int total = 0;
    for (int i = 0; i < numOrders; i++) {
        total += order[i].price * order[i].quantity;
    }
    printf("Total: $%d\n", total);
}

int main() {
    Item menu[100];
    int numMenuItems = 0;
    addItem(menu, numMenuItems, "Coffee", 3);
    addItem(menu, numMenuItems, "Tea", 2);
    addItem(menu, numMenuItems, "Cake", 5);
    addItem(menu, numMenuItems, "Sandwich", 4);

    Order order[10];
    int numOrders = 0;
    addOrder(order, numOrders, "Coffee", 3, 2);
    addOrder(order, numOrders, "Cake", 5, 1);

    printMenu(menu, numMenuItems);
    printOrder(order, numOrders);
    calculateTotal(order, numOrders);

    return 0;
}