//LLAMA2-13B DATASET v1.0 Category: Digital Diary ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define DIARY_MAX_ENTRIES 100
#define ENTRY_MAX_LENGTH 256

typedef struct {
    char date[20];
    char entry[ENTRY_MAX_LENGTH];
} diary_entry_t;

typedef struct {
    diary_entry_t entries[DIARY_MAX_ENTRIES];
    int num_entries;
} diary_t;

void init_diary(diary_t *diary) {
    memset(diary, 0, sizeof(diary_t));
}

void add_entry(diary_t *diary, char *date, char *entry) {
    int i;
    for (i = 0; i < diary->num_entries; i++) {
        if (strcmp(diary->entries[i].date, date) == 0) {
            // Entry already exists, update it
            strcpy(diary->entries[i].entry, entry);
            return;
        }
    }
    // Entry does not exist, add it
    diary->entries[diary->num_entries] = (diary_entry_t) {
        .date = date,
        .entry = entry
    };
    diary->num_entries++;
}

void print_diary(diary_t *diary) {
    int i;
    for (i = 0; i < diary->num_entries; i++) {
        printf("%s: %s\n", diary->entries[i].date, diary->entries[i].entry);
    }
}

int main() {
    diary_t diary;
    init_diary(&diary);

    char date[] = "2022-01-01";
    char entry[] = "First digital diary entry!";
    add_entry(&diary, date, entry);

    date[0] = '2';
    date[1] = '0';
    date[2] = '2';
    date[3] = '-';
    date[4] = '0';
    date[5] = '-';
    date[6] = '1';
    date[7] = '-';
    entry[0] = 'S';
    entry[1] = 'e';
    entry[2] = 'c';
    entry[3] = 'o';
    entry[4] = 'n';
    entry[5] = 'd';
    entry[6] = 'a';
    entry[7] = 'y';
    add_entry(&diary, date, entry);

    print_diary(&diary);

    return 0;
}