//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <semaphore.h>
#include <pthread.h>

#define MAX 5

int count = 0;

sem_t mutex;
sem_t full, empty;

void init_semaphores() {
    sem_init(&mutex, 0, 1);
    sem_init(&full, 0, 0);
    sem_init(&empty, 0, MAX);
}

void producer(int id) {
    int value;

    for (int i = 0; i < 10; i++) {
        sem_wait(&empty);
        sem_wait(&mutex);

        printf("Producer %d produced value %d\n", id, i);
        count++;

        if (count == MAX) {
            printf("Buffer is full. Producer %d is waiting...\n", id);
            sem_post(&mutex);
            sem_post(&full);
            sem_wait(&empty);
        } else {
            printf("Producer %d added value %d to the buffer\n", id, i);
        }

        sem_post(&mutex);
    }
}

void consumer(int id) {
    int value;

    for (int i = 0; i < 10; i++) {
        sem_wait(&full);
        sem_wait(&mutex);

        printf("Consumer %d consumed value %d\n", id, count - 1);
        count--;

        if (count == 0) {
            printf("Buffer is empty. Consumer %d is waiting...\n", id);
            sem_post(&mutex);
            sem_post(&empty);
            sem_wait(&full);
        } else {
            printf("Consumer %d removed value %d from the buffer\n", id, count - 1);
        }

        sem_post(&mutex);
    }
}

int main() {
    pthread_t threads[2];
    int ids[2] = {0, 1};

    init_semaphores();

    pthread_create(&threads[0], NULL, producer, (void *)&ids[0]);
    pthread_create(&threads[1], NULL, consumer, (void *)&ids[1]);

    for (int i = 0; i < 2; i++) {
        pthread_join(threads[i], NULL);
    }

    return 0;
}