//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_DAYS 7

const char *weatherConditions[] = {
    "Sunny",
    "Cloudy",
    "Rainy",
    "Stormy",
    "Snowy",
    "Foggy",
    "Windy"
};

const char *tempConditions[] = {
    "Freezing",
    "Cold",
    "Mild",
    "Warm",
    "Hot"
};

typedef struct {
    char day[10];
    const char *weather;
    const char *temperature;
} WeatherReport;

void generateWeatherReport(WeatherReport *report, int index) {
    // Days of the week
    const char *daysOfWeek[] = {"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    snprintf(report[index].day, sizeof(report[index].day), "%s", daysOfWeek[index]);

    // Randomly assign weather condition and temperature
    report[index].weather = weatherConditions[rand() % (sizeof(weatherConditions) / sizeof(weatherConditions[0]))];
    report[index].temperature = tempConditions[rand() % (sizeof(tempConditions) / sizeof(tempConditions[0]))];
}

void printWeatherReport(const WeatherReport *report) {
    printf("--------------------------------------------------\n");
    printf("            Weekly Weather Forecast               \n");
    printf("--------------------------------------------------\n");
    for (int i = 0; i < NUM_DAYS; i++) {
        printf("|  %s  |   Weather: %-10s |   Temperature: %-8s |\n", 
                report[i].day, report[i].weather, report[i].temperature);
    }
    printf("--------------------------------------------------\n");
}

void displayEnthusiasticMessage() {
    printf("🚀 Welcome to the Weather Simulation Extravaganza! 🌤️\n");
    printf("Prepare to be amazed by the random and wild weather forecast for the week!\n");
}

int main() {
    srand(time(NULL)); // Seed for random number generation

    WeatherReport report[NUM_DAYS];

    displayEnthusiasticMessage();

    // Generate weather report for the week
    for (int i = 0; i < NUM_DAYS; i++) {
        generateWeatherReport(report, i);
    }

    // Print the weather report
    printWeatherReport(report);

    printf("Hope you enjoy the weather! Now grab your sunglasses or an umbrella! ☂️😎\n");

    return 0;
}